chrome.runtime.onMessage.addListener(function(e, sender, sendResponse) {
    const { message, req } = e
    switch (message) {
        case 'XHR':
            request_proxy(req, (res) => {
                console.log(res);
                sendResponse(res);
            });
            break
    }
    return true;
})

function request_proxy(req, sendResponse) {
    var xhr = new XMLHttpRequest();
    xhr.timeout = 30e3;　　
    xhr.open(req.method, req.url, true);
    if (req.headers) {
        for (key in req.headers) {
            xhr.setRequestHeader(key, req.headers[key]);
        }
    }
    xhr.onreadystatechange = function() {
        if (xhr.readyState == 4) {
            sendResponse(xhr.responseText);
        }
    }
    xhr.send(req.data);
}